<?php
/*** Plugin Name: Dynamic User Directory Custom
* Plugin URI: http://sgcustomwebsolutions.com 
* Description: Extends the "Dynamic User Directory" plugin by showing the mo_image meta field as the user avatar.
*  
* Version: 1.0.0 
* Author: Sarah Giles 
* Author URI: http://sgcustomwebsolutions.com 
* License: GPL2 
*/

define('DYNAMIC_USER_DIRECTORY_CUSTOM_DIR_PATH', plugin_dir_path(__FILE__));
define('DYNAMIC_USER_DIRECTORY_CUSTOM_URL', plugin_dir_url(__FILE__));

/**
 * Filter to showing the mo_image meta field as the user avatar
 *
 * @returns the new avatar url. 
 **/
 
function dud_set_avatar_url($user_avatar_url, $user_id, $atts, $img_style)
{
	$profile_photo = get_user_meta( $user_id, 'mo_image', true );
	
	if(!empty($profile_photo))
		return "<img src='". $profile_photo . "'>";
	else
		return $user_avatar_url;	
}

add_filter('dud_set_avatar_url', 'dud_set_avatar_url', 10, 4);